{
  pkgs,
  ...
}: let
  weechat-unwrapped = pkgs.weechat-unwrapped.overrideAttrs (old: let
    version = "4.5.1";
  in {
    inherit version;
    name = "${old.pname}-${version}";
    src = pkgs.fetchurl {
      url = "https://weechat.org/files/src/weechat-${version}.tar.xz";
      hash = "sha256-Z8FDx7xw5om56obfZ0yan/PPRMzJzf8hvmpWHV6vxSg=";
    };
  });
  weechat = pkgs.wrapWeechat weechat-unwrapped {};
in { home.packages = [ weechat ]; }